/**
 * Main script for the BonusThemes.com Blogic Template
 *
 * @package bt_blogic
 * @version 1.0
 * @copyright BonusThemes.com 2008
 * @link http://www.bonusthemes.com/goto/bt_blogic
 */


function bt_add_event(obj, event, func) {
	if (obj.addEventListener)
		obj.addEventListener(event, func, false);
	else if (obj.attachEvent)
		obj.attachEvent('on' + event, func);
}


// CMenu handlers

function blogic_get_wdg(wdg_center) {
	return {
		left: wdg_center.previousSibling.nodeType == 1 ? wdg_center.previousSibling : wdg_center.previousSibling.previousSibling,
		center: wdg_center,
		right: wdg_center.nextSibling.nodeType == 1 ? wdg_center.nextSibling : wdg_center.nextSibling.nextSibling
	}
}

function blogic_ch_create(mi) {
	if (mi.is_header) {
		var wdg = blogic_get_wdg(mi.wdg);
		wdg.left.style.cursor = 'pointer';
		wdg.center.style.cursor = 'pointer';
		wdg.right.style.cursor = 'pointer';
	}
}

function blogic_ch_mouseover(mi) {
	if (document.page_loaded && mi.is_header) {
		var wdg = blogic_get_wdg(mi.wdg);

		mi.panel_ch_x = 0; //wdg.left.offsetWidth;
		mi.panel_ch_y = wdg.center.offsetHeight;

		var obj = wdg.left;
		mi.panel_ch_x += obj.offsetLeft;
		obj = obj.offsetParent;
		while (obj) {
			mi.panel_ch_x += obj.offsetLeft;
			mi.panel_ch_y += obj.offsetTop;
			obj = obj.offsetParent;
		}
		mi.panel_ch_min_w = wdg.left.offsetWidth + wdg.center.offsetWidth + wdg.right.offsetWidth;

		if (typeof mi.td_center_class == 'undefined') {
			mi.td_left_class = wdg.left.className;
			mi.td_center_class = wdg.center.className;
			mi.td_right_class = wdg.right.className;
		}

		wdg.left.className = 'cmenu_hd_sel_l';
		wdg.center.className = 'cmenu_hd_sel_c';
		wdg.right.className = 'cmenu_hd_sel_r';
	}
}

function blogic_menu_close(mi) {
	if (document.page_loaded) {
		var wdg = blogic_get_wdg(mi.wdg);
		if (typeof mi.td_center_class != 'undefined') {
			wdg.left.className = mi.td_left_class;
			wdg.center.className = mi.td_center_class;
			wdg.right.className = mi.td_right_class;
		}
	}
}

function blogic_ch_mouseout(mi) {
	if (mi.is_header && mi.menuitems.length == 0)
		blogic_menu_close(mi);
}

function blogic_ch_panel_hide(mi) {
	if (mi.is_header)
		blogic_menu_close(mi);
}


// page initialization

function blogic_page_init() {
	document.page_loaded = true;

	if (document['cmenu_items']) {
		document['mc'] = new CMenu({
			iname: 'mc',

			edge_min: 'wrapper',

			side: 'down',
			orientation: 'right',

			animate: true,
			anim_step: 10,
			anim_interval: 30,

			transparency: true,
			transparency_ie6: false,

			min_opacity: 0,
			max_opacity: 100,

			ch_create: blogic_ch_create,
			ch_mouseover: blogic_ch_mouseover,
			ch_mouseout: blogic_ch_mouseout,
			ch_panel_hide: blogic_ch_panel_hide,

			panel_offset1_x: 0,
			panel_offset1_y: 0,
			panel_offset2_x: 6,
			panel_offset2_y: 0,

			itemborder_class: 'cmenu_itemborder',
			separator_class: 'cmenu_separator',
			panel_class: 'cmenu_panel',
			panel_tl_class: 'cmenu_tl',
			panel_tc_class: 'cmenu_tc',
			panel_tr_class: 'cmenu_tr',
			panel_ml_class: 'cmenu_ml',
			panel_mr_class: 'cmenu_mr',
			panel_bl_class: 'cmenu_bl',
			panel_bc_class: 'cmenu_bc',
			panel_br_class: 'cmenu_br',

			mi_empty_normal_class: 'cmenu_mi_empty_normal',
			mi_empty_hover_class: 'cmenu_mi_empty_hover',
			mi_full_normal_class: 'cmenu_mi_full_normal',
			mi_full_hover_class: 'cmenu_mi_full_hover'

		});

		var len = document['cmenu_items'].length;
		if (len > 0) {
			for (var i = 0; i < len; i++) {
				var item = document['cmenu_items'][i];

				if (typeof item.parent_id == 'undefined')
					this[item.id] = document['mc'].add_item(item);
				else
					this[item.id] = this[item.parent_id].add_item(item);
			}
		
			document['mc'].run();
		}
	}

	document.side_mods = new Array();
	load_side_positions('left_up');
	load_side_positions('right_up');
}

bt_add_event(window, 'load', blogic_page_init);


function load_side_positions(position_name) {
	var host = document.getElementById(position_name + '_container');
	var node = document.getElementById('pos_' + position_name);

	if (!host || !node)
		return;

	node = node.firstChild;
	var first = true;
	while (node) {
		if (node.nodeType == 1) {
			// if the node is a regular DOM element, handle it as a data source

			// try to find the header
			var header = node.firstChild;
			while (header && header.nodeType != 1)
				header = header.nextSibling;

			var header_str = '';
			if (header && header.tagName == 'H3') {
				header_str = header.firstChild.nodeValue;
				node.removeChild(header);
			}
			else {
				header = null;
			}

			// cache next data block
			var content_node = node;
			node = node.nextSibling;


			// position header
			if (first) {
				first = false;
			}
			else {
				var div = document.createElement('div');
				div.className = 'upmod_modgap';
				host.appendChild(div);
			}

			document.side_mods.push(new SideModule(document.side_mods.length, host, header_str, content_node));
		}
		else {
			// move to the next data block
			node = node.nextSibling;
		}
	}
}

function SideModule(idx, host, header_str, content_node) {
	this.idx = idx;

	var host_header = document.createElement('div');
	host.appendChild(host_header);
	host_header.className = 'upmod_c';

	var header_l = document.createElement('div');
	host_header.appendChild(header_l);
	header_l.className = 'upmod_l';

	var header_r = document.createElement('div');
	header_l.appendChild(header_r);
	header_r.className = 'upmod_r';

	var header_h = document.createElement('div');
	header_r.appendChild(header_h);
	header_h.className = 'upmod_h';
	header_h.appendChild(document.createTextNode(header_str == '' ? '-' : header_str));

	this.host_content = document.createElement('div');
	this.host_content.className = 'upmod_content';
	this.host_content.style.display = 'none';

	var div = document.createElement('div');
	div.className = 'upmod_headergap';
	this.host_content.appendChild(div);

	this.host_content.appendChild(content_node);

	this.host_content.style.visibility = 'hidden';
	this.host_content.style.position = 'absolute';
	this.host_content.style.left = '0px';
	this.host_content.style.top = '0px';
	this.host_content.style.width = host.offsetWidth + 'px';
	this.host_content.style.display = 'block';
	document.getElementsByTagName('body')[0].appendChild(this.host_content);
	this.height = this.host_content.offsetHeight;
	this.host_content.style.display = 'none';
	this.host_content.style.visibility = 'visible';
	this.host_content.style.position = 'static';
	host.appendChild(this.host_content);

	header_h.setAttribute('idx', this.idx);
	header_h.onclick = function () {
		document.side_mods[this.getAttribute('idx')].h_click();
	}

	this.state = 0;
	this.progress = 0;
	this.timer = 0;
	this.interval = 20;
	this.step = 0.2;
}

SideModule.prototype.h_click = function () {
	this.state = this.state > 0 ? -1 : 2;
	if (this.timer == 0)
		this.timer = setTimeout('document.side_mods[' + this.idx + '].h_timer()', this.interval);
}

SideModule.prototype.h_timer = function () {
	this.timer = 0;

	var prev_state = this.state;

	if (this.state == 2) {
		this.progress += (100 - this.progress) * this.step;
		if (this.progress > 100) {
			this.progress = 100;
			this.state = 1;
		}
	}
	else if (this.state == -1) {
		this.progress -= this.progress * this.step;
		if (this.progress < 0) {
			this.progress = 0;
			this.state = 0;
		}
	}

	this.host_content.style.display = this.progress == 0 ? 'none' : 'block';
	this.host_content.style.height = Math.ceil(this.height * this.progress / 100) + 'px';

	if (this.state == 2 || this.state == -1)
		this.timer = setTimeout('document.side_mods[' + this.idx + '].h_timer()', this.interval);
}

var goto_top_type = -1;
var goto_top_itv = 0;

function goto_top_timer() {
	var y = goto_top_type == 1 ? document.documentElement.scrollTop : document.body.scrollTop;
	var moveby = 15;

	y -= Math.ceil(y * moveby / 100);
	if (y < 0)
		y = 0;

	if (goto_top_type == 1)
		document.documentElement.scrollTop = y;
	else
		document.body.scrollTop = y;

	if (y == 0) {
		clearInterval(goto_top_itv);
		goto_top_itv = 0;
	}
}

function goto_top() {
	if (goto_top_itv == 0) {
		if (document.documentElement && document.documentElement.scrollTop)
			goto_top_type = 1;
		else if (document.body && document.body.scrollTop)
			goto_top_type = 2;
		else
			goto_top_type = 0;

		if (goto_top_type > 0)
			goto_top_itv = setInterval('goto_top_timer()', 50);
	}
}

